//
//  PeopleLoader.m
//  People
//
//  Created by Jonathan Diehl on 10.01.10.
//  Copyright 2010 RWTH. All rights reserved.
//

#import "PeopleLoader.h"
#import "Person.h"

@implementation PeopleLoader

@synthesize delegate;

// load the people from the backend
- (void)load;
{
	NSURLRequest *request = [[NSURLRequest alloc] initWithURL:url cachePolicy:NSURLRequestReloadIgnoringCacheData timeoutInterval:3.0];
	connection = [[NSURLConnection alloc] initWithRequest:request delegate:self];
	
	// cleanup
	[request release];
	
	// create new empty data
	[connectionData release];
	connectionData = [[NSMutableData alloc] init];
	
	// start connection
	[connection start];
}


# pragma mark -
# pragma mark init & cleanup

// init
- (id)initWithURL:(NSURL *)anURL;
{
	self = [super init];
	if (self != nil) {
		url = [anURL retain];
	}
	return self;
}

// cleanup
- (void) dealloc
{
	// stop all activity
	[connection cancel];
	[parser abortParsing];
	
	[connection release];
	[connectionData release];
	[parser release];
	[people release];
	[person release];
	[parsedElement release];
	[parsedCharacters release];
	[url release];
	[super dealloc];
}


# pragma mark -
# pragma mark NSURLConnectionDelegate

// received data
- (void)connection:(NSURLConnection *)aConnection didReceiveData:(NSData *)data;
{
	[connectionData appendData:data];
}

// done
- (void)connectionDidFinishLoading:(NSURLConnection *)aConnection;
{
	// setup parser for the connection data
	parser = [[NSXMLParser alloc] initWithData:connectionData];
	[parser setDelegate:self];
	
	// cleanup
	[connection release];
	connection = nil;
	[connectionData release];
	connectionData = nil;
	
	// setup people array and parsed characters string
	people = [[NSMutableArray alloc] init];
	parsedCharacters = [[NSMutableString alloc] init];
	
	// start parsing
	[parser parse];
}

// failed
- (void)connection:(NSURLConnection *)aConnection didFailWithError:(NSError *)error;
{
	[delegate peopleLoader:self didFailWithError:error];
}


# pragma mark -
# pragma mark NSXMLParserDelegate

// parse element
- (void)parser:(NSXMLParser *)aParser didStartElement:(NSString *)elementName namespaceURI:(NSString *)namespaceURI qualifiedName:(NSString *)qualifiedName attributes:(NSDictionary *)attributeDict
{
	// remember the element
	parsedElement = [elementName retain];
	
	// clear the parsed characters
	NSRange range = { location:0, length:[parsedCharacters length] };
	[parsedCharacters deleteCharactersInRange:range];
	
	// create new person if this is a person element
	if([parsedElement isEqualToString:@"person"]) {
		[person release];
		person = [[Person alloc] init];
		[people addObject:person];
	}
}

// done parsing element
- (void)parser:(NSXMLParser *)parser didEndElement:(NSString *)elementName namespaceURI:(NSString *)namespaceURI qualifiedName:(NSString *)qName
{
	// set email property
	if([parsedElement isEqualToString:@"email"]) {
		person.email = [parsedCharacters stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
		
	// set first_name property
	} else if([parsedElement isEqualToString:@"first-name"]) {
		person.first_name = [parsedCharacters stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
		
	// set last_name property
	} else if([parsedElement isEqualToString:@"last-name"]) {
		person.last_name = [parsedCharacters stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
		
	// set id property (this is an integer)
	} else if([parsedElement isEqualToString:@"id"]) {
		person._id = [parsedCharacters intValue];
	}

	// clear parsed element
	[parsedElement release];
	parsedElement = nil;
}

// parse data
- (void)parser:(NSXMLParser *)aParser foundCharacters:(NSString *)string
{
	// rememberd characters
	[parsedCharacters appendString:string];
}

// parser finished
- (void)parserDidEndDocument:(NSXMLParser *)aParser
{
	// inform delegate
	[delegate peopleLoader:self didLoadPeople:[NSArray arrayWithArray:people]];
}



@end
